/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.Collection;
import java.util.Iterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;
import org.pitest.sequence.SlotWrite;

public class ForEachLoopFilter
implements MutationInterceptor {
    private static final boolean DEBUG = false;
    private static final Match<AbstractInsnNode> IGNORE = InstructionMatchers.isA(LineNumberNode.class).or(InstructionMatchers.isA(FrameNode.class));
    private static final Slot<AbstractInsnNode> MUTATED_INSTRUCTION = Slot.create(AbstractInsnNode.class);
    private static final Slot<Boolean> FOUND = Slot.create(Boolean.class);
    private static final SequenceMatcher<AbstractInsnNode> ITERATOR_LOOP = QueryStart.match((Match)Match.never()).or(ForEachLoopFilter.conditionalAtStart()).or(ForEachLoopFilter.conditionalAtEnd()).or(ForEachLoopFilter.arrayConditionalAtEnd()).or(ForEachLoopFilter.arrayConditionalAtStart()).then(ForEachLoopFilter.containMutation(FOUND)).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(IGNORE).withDebug(false));
    private ClassTree currentClass;

    private static SequenceQuery<AbstractInsnNode> conditionalAtEnd() {
        Slot loopStart = Slot.create(LabelNode.class);
        Slot loopEnd = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(ForEachLoopFilter.aMethodCallReturningAnIterator().and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.opCode(58)).then(InstructionMatchers.gotoLabel((SlotWrite<LabelNode>)loopEnd.write())).then(InstructionMatchers.aLabelNode((SlotWrite<LabelNode>)loopStart.write())).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.methodCallTo(ClassName.fromString((String)"java/util/Iterator"), "next").and(ForEachLoopFilter.mutationPoint())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.labelNode((SlotRead<LabelNode>)loopEnd.read())).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.methodCallTo(ClassName.fromString((String)"java/util/Iterator"), "hasNext").and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.aConditionalJumpTo((Slot<LabelNode>)loopStart).and(ForEachLoopFilter.mutationPoint())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> conditionalAtStart() {
        Slot loopStart = Slot.create(LabelNode.class);
        Slot loopEnd = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(ForEachLoopFilter.aMethodCallReturningAnIterator().and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.opCode(58)).then(InstructionMatchers.aLabelNode((SlotWrite<LabelNode>)loopStart.write())).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.methodCallTo(ClassName.fromString((String)"java/util/Iterator"), "hasNext").and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.aConditionalJump().and(InstructionMatchers.jumpsTo((SlotWrite<LabelNode>)loopEnd.write())).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.methodCallTo(ClassName.fromString((String)"java/util/Iterator"), "next").and(ForEachLoopFilter.mutationPoint())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.opCode(167).and(InstructionMatchers.jumpsTo((SlotRead<LabelNode>)loopStart.read()))).then(InstructionMatchers.labelNode((SlotRead<LabelNode>)loopEnd.read())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> arrayConditionalAtEnd() {
        Slot loopStart = Slot.create(LabelNode.class);
        Slot loopEnd = Slot.create(LabelNode.class);
        Slot counter = Slot.create(Integer.class);
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.opCode(190).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.opCode(54)).then(InstructionMatchers.opCode(3).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.anIStore((SlotWrite<Integer>)counter.write()).and(InstructionMatchers.debug("store"))).then(InstructionMatchers.gotoLabel((SlotWrite<LabelNode>)loopEnd.write())).then(InstructionMatchers.aLabelNode((SlotWrite<LabelNode>)loopStart.write())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.incrementsVariable((SlotRead<Integer>)counter.read()).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.labelNode((SlotRead<LabelNode>)loopEnd.read())).then(InstructionMatchers.opCode(21)).then(InstructionMatchers.opCode(21)).then(InstructionMatchers.aConditionalJumpTo((Slot<LabelNode>)loopStart).and(ForEachLoopFilter.mutationPoint())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> arrayConditionalAtStart() {
        Slot loopStart = Slot.create(LabelNode.class);
        Slot loopEnd = Slot.create(LabelNode.class);
        Slot counter = Slot.create(Integer.class);
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.opCode(190).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.opCode(54)).then(InstructionMatchers.opCode(3).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.anIStore((SlotWrite<Integer>)counter.write()).and(InstructionMatchers.debug("store"))).then(InstructionMatchers.aLabelNode((SlotWrite<LabelNode>)loopStart.write())).then(InstructionMatchers.opCode(21)).then(InstructionMatchers.opCode(21)).then(InstructionMatchers.aConditionalJump().and(InstructionMatchers.jumpsTo((SlotWrite<LabelNode>)loopEnd.write())).and(ForEachLoopFilter.mutationPoint())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.incrementsVariable((SlotRead<Integer>)counter.read()).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.opCode(167).and(InstructionMatchers.jumpsTo((SlotRead<LabelNode>)loopStart.read()))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static Match<AbstractInsnNode> aMethodCallReturningAnIterator() {
        return InstructionMatchers.methodCallThatReturns(ClassName.fromClass(Iterator.class));
    }

    private static Match<AbstractInsnNode> mutationPoint() {
        return InstructionMatchers.recordTarget((SlotRead<AbstractInsnNode>)MUTATED_INSTRUCTION.read(), (SlotWrite<Boolean>)FOUND.write());
    }

    private static Match<AbstractInsnNode> containMutation(final Slot<Boolean> found) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode t) {
                return c.retrieve(found.read()).hasSome();
            }
        };
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, (F)Prelude.not(this.mutatesIteratorLoopPlumbing()));
    }

    private F<MutationDetails, Boolean> mutatesIteratorLoopPlumbing() {
        return new F<MutationDetails, Boolean>(){

            public Boolean apply(MutationDetails a) {
                int instruction = a.getInstructionIndex();
                MethodTree method = (MethodTree)ForEachLoopFilter.this.currentClass.methods().findFirst(MethodMatchers.forLocation(a.getId().getLocation())).value();
                AbstractInsnNode mutatedInstruction = (AbstractInsnNode)method.instructions().get(instruction);
                Context context = Context.start(method.instructions(), (boolean)false);
                context.store(MUTATED_INSTRUCTION.write(), (Object)mutatedInstruction);
                return ITERATOR_LOOP.matches(method.instructions(), context);
            }
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
    }
}

