/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jbehave.junit.monitoring;

import de.codecentric.jbehave.junit.monitoring.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.failures.FailingUponPendingStep;
import org.jbehave.core.failures.PassingUponPendingStep;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.StoryReporter;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JUnitScenarioReporter
implements StoryReporter {
    Logger logger = new Logger();
    private RunNotifier notifier;
    private Description currentScenario;
    private Description currentStep;
    private Iterator<Description> scenarioDescriptions;
    private final Description rootDescription;
    private final ArrayList<Description> storyDescriptions;
    private Description currentStoryDescription;
    private Iterator<Description> stepDescriptions;
    private Iterator<Description> exampleDescriptions;
    private Description nextExample;
    int testCounter = 0;
    private final int totalTests;
    private boolean givenStoryContext;
    public Set<Description> failedSteps = new HashSet<Description>();
    private PendingStepStrategy pendingStepStrategy = new PassingUponPendingStep();
    private Keywords keywords;
    private boolean anyScenarioFailedInCurrentStory = false;
    private boolean notifyFinished = true;

    public JUnitScenarioReporter(RunNotifier notifier, int totalTests, Description rootDescription, Keywords keywords, boolean notifyFinished) {
        this.totalTests = totalTests;
        this.rootDescription = rootDescription;
        this.notifier = notifier;
        this.storyDescriptions = rootDescription.getChildren();
        this.keywords = keywords;
        this.notifyFinished = notifyFinished;
    }

    public JUnitScenarioReporter(RunNotifier notifier, int totalTests, Description rootDescription, Keywords keywords) {
        this.totalTests = totalTests;
        this.rootDescription = rootDescription;
        this.notifier = notifier;
        this.storyDescriptions = rootDescription.getChildren();
        this.keywords = keywords;
    }

    public void beforeStory(Story story, boolean isGivenStory) {
        this.logger.info("Before Story: {} {}", story.getName(), isGivenStory ? "(given story)" : "");
        if (isGivenStory) {
            this.notifier.fireTestStarted(this.currentStep);
            this.givenStoryContext = true;
        } else {
            this.anyScenarioFailedInCurrentStory = false;
            if (this.testCounter == 0) {
                this.notifier.fireTestRunStarted(this.rootDescription);
            }
            for (Description storyDescription : this.storyDescriptions) {
                if (storyDescription.isSuite() && storyDescription.getDisplayName().equals(story.getName())) {
                    this.currentStoryDescription = storyDescription;
                    this.notifier.fireTestStarted(storyDescription);
                    this.scenarioDescriptions = storyDescription.getChildren().iterator();
                    if (this.scenarioDescriptions.hasNext()) {
                        this.currentScenario = this.scenarioDescriptions.next();
                    }
                    this.currentStep = this.currentStoryDescription;
                    continue;
                }
                if (!storyDescription.isTest() || storyDescription.getMethodName() == null || !storyDescription.getMethodName().equals(story.getName())) continue;
                this.currentStoryDescription = storyDescription;
                this.notifier.fireTestStarted(this.currentStoryDescription);
                this.currentStep = this.currentStoryDescription;
            }
        }
    }

    public void afterStory(boolean isGivenStory) {
        this.logger.info("After Story: {} {}", this.currentStoryDescription.getDisplayName(), isGivenStory ? "(given story)" : "");
        if (isGivenStory) {
            this.givenStoryContext = false;
            this.notifier.fireTestFinished(this.currentStep);
            this.prepareNextStep();
        } else {
            if (!this.failedSteps.contains(this.currentStoryDescription)) {
                if (!this.anyScenarioFailedInCurrentStory) {
                    this.notifier.fireTestFinished(this.currentStoryDescription);
                } else {
                    this.notifier.fireTestFailure(new Failure(this.currentStoryDescription, (Throwable)new RuntimeException("story failed!")));
                }
                if (this.currentStoryDescription.isTest()) {
                    ++this.testCounter;
                }
            }
            if (this.testCounter == this.totalTests && this.notifyFinished) {
                Result result = new Result();
                this.notifier.fireTestRunFinished(result);
            }
        }
    }

    public void beforeScenario(String title) {
        this.logger.info("Before Scenario: {}", title);
        if (!this.givenStoryContext) {
            this.notifier.fireTestStarted(this.currentScenario);
            ArrayList children = this.currentScenario.getChildren();
            List<Description> examples = this.filterExamples(children);
            if (!examples.isEmpty()) {
                this.exampleDescriptions = examples.iterator();
                if (this.exampleDescriptions.hasNext()) {
                    this.nextExample = this.exampleDescriptions.next();
                }
            }
            if (children.size() > examples.size()) {
                ArrayList<Description> steps = new ArrayList<Description>(this.currentScenario.getChildren());
                steps.removeAll(examples);
                this.stepDescriptions = this.getAllDescendants(steps).iterator();
                if (this.stepDescriptions.hasNext()) {
                    this.currentStep = this.stepDescriptions.next();
                }
            }
        }
    }

    private List<Description> filterExamples(ArrayList<Description> children) {
        for (int i = 0; i < children.size(); ++i) {
            Description child = children.get(i);
            boolean isExample = child.getDisplayName().startsWith(this.keywords.examplesTableRow() + " ");
            if (!isExample) continue;
            return children.subList(i, children.size());
        }
        return Collections.emptyList();
    }

    private Collection<Description> getAllDescendants(ArrayList<Description> steps) {
        ArrayList<Description> descendants = new ArrayList<Description>();
        for (Description child : steps) {
            descendants.add(child);
            descendants.addAll(this.getAllDescendants(child.getChildren()));
        }
        return descendants;
    }

    public void afterScenario() {
        this.logger.info("After Scenario: {}", this.currentScenario.getDisplayName());
        if (!this.givenStoryContext) {
            if (this.failedSteps.size() == 0) {
                this.notifier.fireTestFinished(this.currentScenario);
            } else {
                this.notifier.fireTestFailure(new Failure(this.currentScenario, (Throwable)new RuntimeException("scenario failed!")));
                this.anyScenarioFailedInCurrentStory = true;
                this.failedSteps.clear();
            }
            if (this.scenarioDescriptions.hasNext()) {
                this.currentScenario = this.scenarioDescriptions.next();
                this.logger.debug("--> updating current scenario to {}", this.currentScenario.getDisplayName());
            }
        }
    }

    public void beforeExamples(List<String> arg0, ExamplesTable arg1) {
        this.logger.info("Before Examples: {}", arg0 != null ? arg0 : "n/a");
    }

    public void example(Map<String, String> arg0) {
        this.logger.info("Example: {}", arg0);
        this.stepDescriptions = this.nextExample.getChildren().iterator();
        if (this.stepDescriptions.hasNext()) {
            this.currentStep = this.stepDescriptions.next();
        }
        if (this.exampleDescriptions.hasNext()) {
            this.nextExample = this.exampleDescriptions.next();
        }
    }

    public void afterExamples() {
        this.logger.info("{}", "afterExamples");
    }

    public void beforeStep(String title) {
        this.logger.info("Before Step: {}", title);
        if (!this.givenStoryContext) {
            this.notifier.fireTestStarted(this.currentStep);
        }
    }

    public void failed(String step, Throwable e) {
        if (e instanceof UUIDExceptionWrapper) {
            e = ((UUIDExceptionWrapper)e).getCause();
        }
        this.logger.info("Step Failed: {} (cause: {})", step, e.getMessage());
        if (!this.givenStoryContext) {
            this.notifier.fireTestFailure(new Failure(this.currentStep, e));
            this.notifier.fireTestFinished(this.currentStep);
            this.failedSteps.add(this.currentStep);
            this.prepareNextStep();
        }
    }

    public void successful(String step) {
        this.logger.info("Step Succesful: {}", step);
        if (!this.givenStoryContext) {
            this.notifier.fireTestFinished(this.currentStep);
            this.prepareNextStep();
        }
    }

    private void prepareNextStep() {
        if (this.currentStep.isTest()) {
            ++this.testCounter;
        }
        if (this.stepDescriptions != null && this.stepDescriptions.hasNext()) {
            this.currentStep = this.stepDescriptions.next();
        }
    }

    public void pending(String arg0) {
        this.logger.info("Pending: {}", arg0);
        if (!this.givenStoryContext) {
            if (this.pendingStepStrategy instanceof FailingUponPendingStep) {
                this.notifier.fireTestStarted(this.currentStep);
                this.notifier.fireTestFailure(new Failure(this.currentStep, (Throwable)new RuntimeException("Step is pending!")));
                this.failedSteps.add(this.currentStep);
                this.notifier.fireTestFinished(this.currentStep);
            } else {
                this.notifier.fireTestIgnored(this.currentStep);
            }
            this.prepareNextStep();
        }
    }

    public void ignorable(String arg0) {
        this.logger.info("Ignorable: {}", arg0);
        if (!this.givenStoryContext) {
            this.notifier.fireTestIgnored(this.currentStep);
            this.prepareNextStep();
        }
    }

    public void notPerformed(String arg0) {
        this.logger.info("Not performed: {}", arg0);
        if (!this.givenStoryContext) {
            this.notifier.fireTestIgnored(this.currentStep);
            this.prepareNextStep();
        }
    }

    public void scenarioNotAllowed(Scenario arg0, String arg1) {
        this.logger.info("Scenario not allowed: {} {}", arg0, arg1);
        this.notifier.fireTestIgnored(this.currentStep);
        this.notifier.fireTestIgnored(this.currentScenario);
    }

    public void dryRun() {
        this.logger.info("{}", "dryRun");
    }

    public void failedOutcomes(String arg0, OutcomesTable arg1) {
        this.logger.info("Failed outcomes: {}", arg0);
    }

    public void givenStories(GivenStories arg0) {
        this.logger.info("Given Stories: {}", arg0);
    }

    public void givenStories(List<String> arg0) {
        this.logger.info("Given Stories (List): {}", arg0);
    }

    public void narrative(Narrative arg0) {
        this.logger.info("Narrative: {}", arg0);
    }

    public void pendingMethods(List<String> arg0) {
        this.logger.info("Pending methods: {}", arg0);
    }

    public void restarted(String arg0, Throwable arg1) {
        this.logger.info("Restarted: {} ({})", arg0, arg1);
    }

    public void scenarioMeta(Meta arg0) {
        this.logger.info("Meta: {}", arg0);
    }

    public void storyCancelled(Story arg0, StoryDuration arg1) {
        this.logger.info("Story cancelled: {} after {}", arg0, arg1);
        System.out.println("JBehave2JunitReporter.storyCancelled()");
    }

    public void storyNotAllowed(Story arg0, String arg1) {
        this.logger.info("Story not allowed: {}, {}", arg0, arg1);
    }

    public void usePendingStepStrategy(PendingStepStrategy strategy) {
        this.pendingStepStrategy = strategy;
    }

    public void lifecyle(Lifecycle lifecycle) {
        this.logger.info("Story lifecycle: {}", lifecycle);
    }
}

