/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jbehave.core.model.TableUtils;

public class TableTransformers {
    public static final String FROM_LANDSCAPE = "FROM_LANDSCAPE";
    public static final String FORMATTING = "FORMATTING";
    public static final String REPLACING = "REPLACING";
    private final Map<String, TableTransformer> transformers = new HashMap<String, TableTransformer>();

    public TableTransformers() {
        this.useTransformer(FROM_LANDSCAPE, new FromLandscape());
        this.useTransformer(FORMATTING, new Formatting());
        this.useTransformer(REPLACING, new Replacing());
    }

    public String transform(String transformerName, String tableAsString, Properties properties) {
        TableTransformer transformer = this.transformers.get(transformerName);
        if (transformer != null) {
            return transformer.transform(tableAsString, properties);
        }
        return tableAsString;
    }

    public void useTransformer(String name, TableTransformer transformer) {
        this.transformers.put(name, transformer);
    }

    public static class Replacing
    implements TableTransformer {
        @Override
        public String transform(String tableAsString, Properties properties) {
            String replacing = properties.getProperty("replacing");
            String replacement = properties.getProperty("replacement");
            if (replacing == null || replacement == null) {
                return tableAsString;
            }
            return tableAsString.replace(replacing, replacement);
        }
    }

    public static class Formatting
    implements TableTransformer {
        private static final String ROW_SEPARATOR = "\n";

        @Override
        public String transform(String tableAsString, Properties properties) {
            boolean trim = Boolean.parseBoolean(properties.getProperty("trim", "true"));
            String ignorableSeparator = properties.getProperty("ignorableSeparator", "|--");
            String headerSeparator = properties.getProperty("headerSeparator", "|");
            String valueSeparator = properties.getProperty("valueSeparator", "|");
            ArrayList<List<String>> data = new ArrayList<List<String>>();
            for (String rowAsString : tableAsString.split(ROW_SEPARATOR)) {
                if (this.ignoreRow(rowAsString, ignorableSeparator)) continue;
                if (rowAsString.contains(headerSeparator)) {
                    data.add(TableUtils.parseRow(rowAsString, headerSeparator, trim));
                    continue;
                }
                data.add(TableUtils.parseRow(rowAsString, valueSeparator, trim));
            }
            StringBuilder builder = new StringBuilder();
            Map<Integer, Integer> maxWidths = this.maxWidth(data);
            for (int r = 0; r < data.size(); ++r) {
                String formattedRow = this.formatRow((List)data.get(r), maxWidths, r == 0 ? headerSeparator : valueSeparator);
                builder.append(formattedRow).append(ROW_SEPARATOR);
            }
            return builder.toString();
        }

        private boolean ignoreRow(String rowAsString, String ignorableSeparator) {
            return rowAsString.startsWith(ignorableSeparator) || rowAsString.length() == 0;
        }

        private Map<Integer, Integer> maxWidth(List<List<String>> data) {
            HashMap<Integer, Integer> maxWidths = new HashMap<Integer, Integer>();
            for (List<String> row : data) {
                for (int c = 0; c < row.size(); ++c) {
                    String cell = row.get(c).trim();
                    Integer width = (Integer)maxWidths.get(c);
                    int length = cell.length();
                    if (width != null && length <= width) continue;
                    width = length;
                    maxWidths.put(c, width);
                }
            }
            return maxWidths;
        }

        private String formatRow(List<String> row, Map<Integer, Integer> maxWidths, String separator) {
            StringBuilder builder = new StringBuilder();
            builder.append(separator);
            for (int c = 0; c < row.size(); ++c) {
                builder.append(this.formatValue(row.get(c).trim(), maxWidths.get(c))).append(separator);
            }
            return builder.toString();
        }

        private String formatValue(String value, int width) {
            if (value.length() < width) {
                return value + this.padding(width - value.length());
            }
            return value;
        }

        private String padding(int size) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                builder.append(' ');
            }
            return builder.toString();
        }
    }

    public static class FromLandscape
    implements TableTransformer {
        private static final String ROW_SEPARATOR = "\n";

        @Override
        public String transform(String tableAsString, Properties properties) {
            boolean trim = Boolean.parseBoolean(properties.getProperty("trim", "true"));
            String ignorableSeparator = properties.getProperty("ignorableSeparator", "|--");
            String headerSeparator = properties.getProperty("headerSeparator", "|");
            String valueSeparator = properties.getProperty("valueSeparator", "|");
            LinkedHashMap<String, ArrayList<String>> data = new LinkedHashMap<String, ArrayList<String>>();
            for (String rowAsString : tableAsString.split(ROW_SEPARATOR)) {
                if (this.ignoreRow(rowAsString, ignorableSeparator)) continue;
                List<String> values = TableUtils.parseRow(rowAsString, valueSeparator, trim);
                String header = values.get(0);
                ArrayList<String> rowValues = new ArrayList<String>(values);
                rowValues.remove(0);
                data.put(header, rowValues);
            }
            StringBuilder builder = new StringBuilder();
            int numberOfRows = 1;
            builder.append(headerSeparator);
            for (String header : data.keySet()) {
                builder.append(header).append(headerSeparator);
                numberOfRows = ((List)data.get(header)).size();
            }
            builder.append(ROW_SEPARATOR);
            for (int r = 0; r < numberOfRows; ++r) {
                builder.append(valueSeparator);
                for (List rows : data.values()) {
                    builder.append((String)rows.get(r)).append(valueSeparator);
                }
                builder.append(ROW_SEPARATOR);
            }
            return builder.toString();
        }

        private boolean ignoreRow(String rowAsString, String ignorableSeparator) {
            return rowAsString.startsWith(ignorableSeparator) || rowAsString.length() == 0;
        }
    }

    public static interface TableTransformer {
        public String transform(String var1, Properties var2);
    }
}

