/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.model.Description;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.ExamplesTableFactory;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.parsers.StoryParser;

public class RegexStoryParser
implements StoryParser {
    private static final String NONE = "";
    private final Keywords keywords;
    private final ExamplesTableFactory tableFactory;

    public RegexStoryParser() {
        this(new LocalizedKeywords());
    }

    public RegexStoryParser(Keywords keywords) {
        this(keywords, new ExamplesTableFactory(keywords));
    }

    public RegexStoryParser(ExamplesTableFactory tableFactory) {
        this(tableFactory.keywords(), tableFactory);
    }

    public RegexStoryParser(Keywords keywords, ExamplesTableFactory tableFactory) {
        this.keywords = keywords;
        this.tableFactory = tableFactory;
        this.tableFactory.useKeywords(keywords);
    }

    public RegexStoryParser(Configuration configuration) {
        this.keywords = configuration.keywords();
        this.tableFactory = new ExamplesTableFactory(configuration);
    }

    @Override
    public Story parseStory(String storyAsText) {
        return this.parseStory(storyAsText, null);
    }

    @Override
    public Story parseStory(String storyAsText, String storyPath) {
        Description description = this.parseDescriptionFrom(storyAsText);
        Meta meta = this.parseStoryMetaFrom(storyAsText);
        Narrative narrative = this.parseNarrativeFrom(storyAsText);
        GivenStories givenStories = this.parseGivenStories(storyAsText);
        Lifecycle lifecycle = this.parseLifecycle(storyAsText);
        List<Scenario> scenarios = this.parseScenariosFrom(storyAsText);
        Story story = new Story(storyPath, description, meta, narrative, givenStories, lifecycle, scenarios);
        if (storyPath != null) {
            story.namedAs(new File(storyPath).getName());
        }
        return story;
    }

    private Description parseDescriptionFrom(String storyAsText) {
        Matcher findingDescription = this.findingDescription().matcher(storyAsText);
        if (findingDescription.matches()) {
            return new Description(findingDescription.group(1).trim());
        }
        return Description.EMPTY;
    }

    private Meta parseStoryMetaFrom(String storyAsText) {
        Matcher findingMeta = this.findingStoryMeta().matcher(this.preScenarioText(storyAsText));
        if (findingMeta.matches()) {
            String meta = findingMeta.group(1).trim();
            return Meta.createMeta(meta, this.keywords);
        }
        return Meta.EMPTY;
    }

    private String preScenarioText(String storyAsText) {
        String[] split = storyAsText.split(this.keywords.scenario());
        return split.length > 0 ? split[0] : storyAsText;
    }

    private Narrative parseNarrativeFrom(String storyAsText) {
        Matcher findingNarrative = this.findingNarrative().matcher(storyAsText);
        if (findingNarrative.matches()) {
            String narrative = findingNarrative.group(1).trim();
            return this.createNarrative(narrative);
        }
        return Narrative.EMPTY;
    }

    private Narrative createNarrative(String narrative) {
        Matcher findingElements = this.findingNarrativeElements().matcher(narrative);
        if (findingElements.matches()) {
            String inOrderTo = findingElements.group(1).trim();
            String asA = findingElements.group(2).trim();
            String iWantTo = findingElements.group(3).trim();
            return new Narrative(inOrderTo, asA, iWantTo);
        }
        Matcher findingAlternativeElements = this.findingAlternativeNarrativeElements().matcher(narrative);
        if (findingAlternativeElements.matches()) {
            String asA = findingAlternativeElements.group(1).trim();
            String iWantTo = findingAlternativeElements.group(2).trim();
            String soThat = findingAlternativeElements.group(3).trim();
            return new Narrative(NONE, asA, iWantTo, soThat);
        }
        return Narrative.EMPTY;
    }

    private GivenStories parseGivenStories(String storyAsText) {
        Matcher findingGivenStories;
        String scenarioKeyword = this.keywords.scenario();
        String beforeScenario = NONE;
        if (StringUtils.contains((CharSequence)storyAsText, (CharSequence)scenarioKeyword)) {
            beforeScenario = StringUtils.substringBefore((String)storyAsText, (String)scenarioKeyword);
        }
        String givenStories = (findingGivenStories = this.findingStoryGivenStories().matcher(beforeScenario)).find() ? findingGivenStories.group(1).trim() : NONE;
        return new GivenStories(givenStories);
    }

    private Lifecycle parseLifecycle(String storyAsText) {
        Matcher findingLifecycle;
        String scenarioKeyword = this.keywords.scenario();
        String beforeScenario = NONE;
        if (StringUtils.contains((CharSequence)storyAsText, (CharSequence)scenarioKeyword)) {
            beforeScenario = StringUtils.substringBefore((String)storyAsText, (String)scenarioKeyword);
        }
        String lifecycle = (findingLifecycle = this.findingLifecycle().matcher(beforeScenario)).find() ? findingLifecycle.group(1).trim() : NONE;
        Matcher findingBeforeAndAfter = Pattern.compile(".*" + this.keywords.before() + "(.*)\\s*" + this.keywords.after() + "(.*)\\s*", 32).matcher(lifecycle);
        if (findingBeforeAndAfter.matches()) {
            String beforeLifecycle = findingBeforeAndAfter.group(1).trim();
            Lifecycle.Steps beforeSteps = this.parseBeforeLifecycle(beforeLifecycle);
            String afterLifecycle = findingBeforeAndAfter.group(2).trim();
            Lifecycle.Steps[] afterSteps = this.parseAfterLifecycle(afterLifecycle);
            return new Lifecycle(beforeSteps, afterSteps);
        }
        Matcher findingBefore = Pattern.compile(".*" + this.keywords.before() + "(.*)\\s*", 32).matcher(lifecycle);
        if (findingBefore.matches()) {
            String beforeLifecycle = findingBefore.group(1).trim();
            Lifecycle.Steps beforeSteps = this.parseBeforeLifecycle(beforeLifecycle);
            return new Lifecycle(beforeSteps, new Lifecycle.Steps(new ArrayList<String>()));
        }
        Matcher findingAfter = Pattern.compile(".*" + this.keywords.after() + "(.*)\\s*", 32).matcher(lifecycle);
        if (findingAfter.matches()) {
            Lifecycle.Steps beforeSteps = Lifecycle.Steps.EMPTY;
            String afterLifecycle = findingAfter.group(1).trim();
            Lifecycle.Steps[] afterSteps = this.parseAfterLifecycle(afterLifecycle);
            return new Lifecycle(beforeSteps, afterSteps);
        }
        return Lifecycle.EMPTY;
    }

    private Lifecycle.Steps parseBeforeLifecycle(String lifecycleAsText) {
        return new Lifecycle.Steps(this.findSteps(this.startingWithNL(lifecycleAsText)));
    }

    private Lifecycle.Steps[] parseAfterLifecycle(String lifecycleAsText) {
        ArrayList<Lifecycle.Steps> list = new ArrayList<Lifecycle.Steps>();
        for (String byOutcome : lifecycleAsText.split(this.keywords.outcome())) {
            if ((byOutcome = byOutcome.trim()).isEmpty()) continue;
            String outcomeAsText = this.findOutcome(byOutcome);
            String filtersAsText = this.findFilters(StringUtils.removeStart((String)byOutcome, (String)outcomeAsText));
            List<String> steps = this.findSteps(this.startingWithNL(StringUtils.removeStart((String)byOutcome, (String)filtersAsText)));
            list.add(new Lifecycle.Steps(this.parseOutcome(outcomeAsText), this.parseFilters(filtersAsText), steps));
        }
        return list.toArray(new Lifecycle.Steps[list.size()]);
    }

    private String findOutcome(String stepsByOutcome) {
        Matcher findingOutcome = this.findingLifecycleOutcome().matcher(stepsByOutcome);
        if (findingOutcome.matches()) {
            return findingOutcome.group(1).trim();
        }
        return this.keywords.outcomeAny();
    }

    private AfterScenario.Outcome parseOutcome(String outcomeAsText) {
        if (outcomeAsText.equals(this.keywords.outcomeSuccess())) {
            return AfterScenario.Outcome.SUCCESS;
        }
        if (outcomeAsText.equals(this.keywords.outcomeFailure())) {
            return AfterScenario.Outcome.FAILURE;
        }
        return AfterScenario.Outcome.ANY;
    }

    private String findFilters(String stepsByFilters) {
        Matcher findingFilters = this.findingLifecycleFilters().matcher(stepsByFilters.trim());
        if (findingFilters.matches()) {
            return findingFilters.group(1).trim();
        }
        return NONE;
    }

    private String parseFilters(String filtersAsText) {
        return StringUtils.removeStart((String)filtersAsText, (String)this.keywords.metaFilter()).trim();
    }

    private List<Scenario> parseScenariosFrom(String storyAsText) {
        ArrayList<Scenario> parsed = new ArrayList<Scenario>();
        for (String scenarioAsText : this.splitScenarios(storyAsText)) {
            parsed.add(this.parseScenario(scenarioAsText));
        }
        return parsed;
    }

    private List<String> splitScenarios(String storyAsText) {
        ArrayList<String> scenarios = new ArrayList<String>();
        String scenarioKeyword = this.keywords.scenario();
        if (StringUtils.contains((CharSequence)storyAsText, (CharSequence)scenarioKeyword)) {
            storyAsText = StringUtils.substringAfter((String)storyAsText, (String)scenarioKeyword);
        }
        for (String scenarioAsText : storyAsText.split(scenarioKeyword)) {
            if (scenarioAsText.trim().length() <= 0) continue;
            scenarios.add(scenarioKeyword + "\n" + scenarioAsText);
        }
        return scenarios;
    }

    private Scenario parseScenario(String scenarioAsText) {
        String title = this.findScenarioTitle(scenarioAsText);
        String scenarioWithoutKeyword = StringUtils.removeStart((String)scenarioAsText, (String)this.keywords.scenario()).trim();
        String scenarioWithoutTitle = StringUtils.removeStart((String)scenarioWithoutKeyword, (String)title);
        scenarioWithoutTitle = this.startingWithNL(scenarioWithoutTitle);
        Meta meta = this.findScenarioMeta(scenarioWithoutTitle);
        ExamplesTable examplesTable = this.findExamplesTable(scenarioWithoutTitle);
        GivenStories givenStories = this.findScenarioGivenStories(scenarioWithoutTitle);
        if (givenStories.requireParameters()) {
            givenStories.useExamplesTable(examplesTable);
        }
        List<String> steps = this.findSteps(scenarioWithoutTitle);
        return new Scenario(title, meta, givenStories, examplesTable, steps);
    }

    private String startingWithNL(String text) {
        if (!text.startsWith("\n")) {
            return "\n" + text;
        }
        return text;
    }

    private String findScenarioTitle(String scenarioAsText) {
        Matcher findingTitle = this.findingScenarioTitle().matcher(scenarioAsText);
        return findingTitle.find() ? findingTitle.group(1).trim() : NONE;
    }

    private Meta findScenarioMeta(String scenarioAsText) {
        Matcher findingMeta = this.findingScenarioMeta().matcher(scenarioAsText);
        if (findingMeta.matches()) {
            String meta = findingMeta.group(1).trim();
            return Meta.createMeta(meta, this.keywords);
        }
        return Meta.EMPTY;
    }

    private ExamplesTable findExamplesTable(String scenarioAsText) {
        Matcher findingTable = this.findingExamplesTable().matcher(scenarioAsText);
        String tableInput = findingTable.find() ? findingTable.group(1).trim() : NONE;
        return this.tableFactory.createExamplesTable(tableInput);
    }

    private GivenStories findScenarioGivenStories(String scenarioAsText) {
        Matcher findingGivenStories = this.findingScenarioGivenStories().matcher(scenarioAsText);
        String givenStories = findingGivenStories.find() ? findingGivenStories.group(1).trim() : NONE;
        return new GivenStories(givenStories);
    }

    private List<String> findSteps(String stepsAsText) {
        Matcher matcher = this.findingSteps().matcher(stepsAsText);
        ArrayList<String> steps = new ArrayList<String>();
        int startAt = 0;
        while (matcher.find(startAt)) {
            steps.add(StringUtils.substringAfter((String)matcher.group(1), (String)"\n"));
            startAt = matcher.start(4);
        }
        return steps;
    }

    private Pattern findingDescription() {
        String metaOrNarrativeOrLifecycleOrScenario = this.concatenateWithOr(this.keywords.meta(), this.keywords.narrative(), this.keywords.lifecycle(), this.keywords.scenario());
        return Pattern.compile("(.*?)(" + metaOrNarrativeOrLifecycleOrScenario + ").*", 32);
    }

    private Pattern findingStoryMeta() {
        String narrativeOrLifecycleOrGivenStories = this.concatenateWithOr(this.keywords.narrative(), this.keywords.lifecycle(), this.keywords.givenStories());
        return Pattern.compile(".*" + this.keywords.meta() + "(.*?)\\s*(\\Z|" + narrativeOrLifecycleOrGivenStories + ").*", 32);
    }

    private Pattern findingNarrative() {
        String givenStoriesOrLifecycleOrScenario = this.concatenateWithOr(this.keywords.givenStories(), this.keywords.lifecycle(), this.keywords.scenario());
        return Pattern.compile(".*" + this.keywords.narrative() + "(.*?)\\s*(" + givenStoriesOrLifecycleOrScenario + ").*", 32);
    }

    private Pattern findingNarrativeElements() {
        return Pattern.compile(".*" + this.keywords.inOrderTo() + "(.*)\\s*" + this.keywords.asA() + "(.*)\\s*" + this.keywords.iWantTo() + "(.*)", 32);
    }

    private Pattern findingAlternativeNarrativeElements() {
        return Pattern.compile(".*" + this.keywords.asA() + "(.*)\\s*" + this.keywords.iWantTo() + "(.*)\\s*" + this.keywords.soThat() + "(.*)", 32);
    }

    private Pattern findingStoryGivenStories() {
        String lifecycleOrScenario = this.concatenateWithOr(this.keywords.lifecycle(), this.keywords.scenario());
        return Pattern.compile(".*" + this.keywords.givenStories() + "(.*?)\\s*(\\Z|" + lifecycleOrScenario + ").*", 32);
    }

    private Pattern findingLifecycle() {
        return Pattern.compile(".*" + this.keywords.lifecycle() + "\\s*(.*)", 32);
    }

    private Pattern findingLifecycleOutcome() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        String outcomes = this.concatenateWithOr(this.keywords.outcomeAny(), this.keywords.outcomeSuccess(), this.keywords.outcomeFailure());
        return Pattern.compile("\\s*(" + outcomes + ")\\s*(" + this.keywords.metaFilter() + "|" + startingWords + ").*", 32);
    }

    private Pattern findingLifecycleFilters() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        String filters = this.concatenateWithOr(this.keywords.metaFilter());
        return Pattern.compile("\\s*(" + filters + "[\\w\\+\\-\\_\\s]*)(" + startingWords + ").*", 32);
    }

    private Pattern findingScenarioTitle() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        return Pattern.compile(this.keywords.scenario() + "((.)*?)\\s*(" + this.keywords.meta() + "|" + startingWords + ").*", 32);
    }

    private Pattern findingScenarioMeta() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        return Pattern.compile(".*" + this.keywords.meta() + "(.*?)\\s*(" + this.keywords.givenStories() + "|" + startingWords + ").*", 32);
    }

    private Pattern findingScenarioGivenStories() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        return Pattern.compile("\\n" + this.keywords.givenStories() + "((.|\\n)*?)\\s*(" + startingWords + ").*", 32);
    }

    private Pattern findingSteps() {
        String initialStartingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        String followingStartingWords = this.concatenateWithOr("\\n", "\\s", this.keywords.startingWords());
        return Pattern.compile("((" + initialStartingWords + ")\\s(.)*?)\\s*(\\Z|" + followingStartingWords + "|\\n" + this.keywords.examplesTable() + ")", 32);
    }

    private Pattern findingExamplesTable() {
        return Pattern.compile("\\n" + this.keywords.examplesTable() + "\\s*(.*)", 32);
    }

    private String concatenateWithOr(String ... keywords) {
        return this.concatenateWithOr((String)null, (String)null, keywords);
    }

    private String concatenateWithOr(String beforeKeyword, String afterKeyword, String[] keywords) {
        StringBuilder builder = new StringBuilder();
        String before = beforeKeyword != null ? beforeKeyword : NONE;
        String after = afterKeyword != null ? afterKeyword : NONE;
        for (String keyword : keywords) {
            builder.append(before).append(keyword).append(after).append("|");
        }
        return StringUtils.removeEnd((String)builder.toString(), (String)"|");
    }
}

