/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.ClassPathRoot;
import org.pitest.classpath.IOHeavyRoot;

public class NameCachingRoot
implements ClassPathRoot {
    private final ClassPathRoot child;
    private SoftReference<Collection<String>> cache;

    public NameCachingRoot(ClassPathRoot child) {
        this.child = child;
    }

    @Override
    public URL getResource(String name) throws MalformedURLException {
        return this.child.getResource(name);
    }

    @Override
    public InputStream getData(String name) throws IOException {
        Collection<String> names = this.classNames();
        if (!names.contains(ClassName.fromString(name).asJavaName())) {
            return null;
        }
        return this.child.getData(name);
    }

    @Override
    public Collection<String> classNames() {
        Collection<String> cachedNames;
        if (this.cache != null && (cachedNames = this.cache.get()) != null) {
            return cachedNames;
        }
        Collection<String> names = this.child.classNames();
        this.cache = new SoftReference<Collection<String>>(names);
        return names;
    }

    @Override
    public Optional<String> cacheLocation() {
        return this.child.cacheLocation();
    }

    public static Function<ClassPathRoot, ClassPathRoot> toCachingRoot() {
        return a -> {
            if (a instanceof IOHeavyRoot) {
                return new NameCachingRoot((ClassPathRoot)a);
            }
            return a;
        };
    }
}

