/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.analysis;

import java.util.List;
import org.pitest.coverage.analysis.Block;
import org.pitest.mutationtest.engine.gregor.analysis.InstructionCounter;
import org.pitest.reloc.asm.Handle;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.commons.AdviceAdapter;

abstract class AbstractCoverageStrategy
extends AdviceAdapter {
    protected final MethodVisitor methodVisitor;
    protected final int classId;
    protected final int probeOffset;
    protected final List<Block> blocks;
    private final InstructionCounter counter;
    private final Label before = new Label();
    private final Label handler = new Label();
    protected int probeCount = 0;

    AbstractCoverageStrategy(List<Block> blocks, InstructionCounter counter, int classId, MethodVisitor writer, int access, String name, String desc, int probeOffset) {
        super(458752, writer, access, name, desc);
        this.methodVisitor = writer;
        this.classId = classId;
        this.counter = counter;
        this.blocks = blocks;
        this.probeOffset = probeOffset;
    }

    abstract void prepare();

    abstract void generateProbeReportCode();

    abstract void insertProbe();

    @Override
    public void visitCode() {
        super.visitCode();
        this.prepare();
        this.mv.visitLabel(this.before);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitTryCatchBlock(this.before, this.handler, this.handler, null);
        this.mv.visitLabel(this.handler);
        this.generateProbeReportCode();
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack, this.nextLocal);
    }

    @Override
    protected void onMethodExit(int opcode) {
        if (opcode != 191) {
            this.generateProbeReportCode();
        }
    }

    protected void pushConstant(int value) {
        switch (value) {
            case 0: {
                this.mv.visitInsn(3);
                break;
            }
            case 1: {
                this.mv.visitInsn(4);
                break;
            }
            case 2: {
                this.mv.visitInsn(5);
                break;
            }
            case 3: {
                this.mv.visitInsn(6);
                break;
            }
            case 4: {
                this.mv.visitInsn(7);
                break;
            }
            case 5: {
                this.mv.visitInsn(8);
                break;
            }
            default: {
                if (value <= 127) {
                    this.mv.visitIntInsn(16, value);
                    break;
                }
                if (value <= Short.MAX_VALUE) {
                    this.mv.visitIntInsn(17, value);
                    break;
                }
                this.mv.visitLdcInsn(value);
            }
        }
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.insertProbeIfAppropriate();
        super.visitFrame(type, nLocal, local, nStack, stack);
    }

    @Override
    public void visitInsn(int opcode) {
        this.insertProbeIfAppropriate();
        super.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.insertProbeIfAppropriate();
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.insertProbeIfAppropriate();
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.insertProbeIfAppropriate();
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.insertProbeIfAppropriate();
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.insertProbeIfAppropriate();
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.insertProbeIfAppropriate();
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.insertProbeIfAppropriate();
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        super.visitLabel(label);
        this.insertProbeIfAppropriate();
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.insertProbeIfAppropriate();
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.insertProbeIfAppropriate();
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.insertProbeIfAppropriate();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.insertProbeIfAppropriate();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.insertProbeIfAppropriate();
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.insertProbeIfAppropriate();
        super.visitLineNumber(line, start);
    }

    private void insertProbeIfAppropriate() {
        if (this.needsProbe(this.counter.currentInstructionCount())) {
            this.insertProbe();
            ++this.probeCount;
        }
    }

    private boolean needsProbe(int currentInstructionCount) {
        for (Block each : this.blocks) {
            if (!each.firstInstructionIs(currentInstructionCount - 1)) continue;
            return true;
        }
        return false;
    }
}

