/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.execute;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.pitest.boot.HotSwapAgent;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.ClassPathByteArraySource;
import org.pitest.classpath.ClassloaderByteArraySource;
import org.pitest.coverage.CoverageTransformer;
import org.pitest.coverage.execute.CoverageOptions;
import org.pitest.coverage.execute.CoveragePipe;
import org.pitest.coverage.execute.CoverageWorker;
import org.pitest.coverage.execute.DependencyFilter;
import org.pitest.coverage.execute.JavassistCoverageInterceptor;
import org.pitest.dependency.DependencyExtractor;
import org.pitest.functional.prelude.Prelude;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.config.ClientPluginServices;
import org.pitest.mutationtest.config.MinionSettings;
import org.pitest.mutationtest.mocksupport.BendJavassistToMyWillTransformer;
import org.pitest.mutationtest.mocksupport.JavassistInputStreamInterceptorAdapater;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.execute.FindTestUnits;
import org.pitest.util.ExitCode;
import org.pitest.util.Glob;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Log;
import org.pitest.util.SafeDataInputStream;
import org.pitest.util.Unchecked;
import sun.pitest.CodeCoverageStore;

public class CoverageMinion {
    private static final Logger LOG = Log.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CoverageMinion.enablePowerMockSupport();
        ExitCode exitCode = ExitCode.OK;
        Socket s = null;
        CoveragePipe invokeQueue = null;
        try {
            int port = Integer.parseInt(args[0]);
            s = new Socket("localhost", port);
            SafeDataInputStream dis = new SafeDataInputStream(s.getInputStream());
            CoverageOptions paramsFromParent = dis.read(CoverageOptions.class);
            Log.setVerbose(paramsFromParent.isVerbose());
            invokeQueue = new CoveragePipe(new BufferedOutputStream(s.getOutputStream()));
            CodeCoverageStore.init(invokeQueue);
            HotSwapAgent.addTransformer(new CoverageTransformer(CoverageMinion.convertToJVMClassFilter(paramsFromParent.getFilter())));
            List<TestUnit> tus = CoverageMinion.getTestsFromParent(dis, paramsFromParent);
            LOG.info(tus.size() + " tests received");
            CoverageWorker worker = new CoverageWorker(invokeQueue, tus);
            worker.run();
        }
        catch (PitHelpError phe) {
            LOG.log(Level.SEVERE, phe.getMessage());
            exitCode = ExitCode.JUNIT_ISSUE;
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.out);
            LOG.log(Level.SEVERE, "Error calculating coverage. Process will exit.", ex);
            exitCode = ExitCode.UNKNOWN_ERROR;
        }
        finally {
            if (invokeQueue != null) {
                invokeQueue.end(exitCode);
            }
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (IOException e) {
                throw Unchecked.translateCheckedException(e);
            }
        }
        System.exit(exitCode.getCode());
    }

    private static void enablePowerMockSupport() {
        HotSwapAgent.addTransformer(new BendJavassistToMyWillTransformer(Prelude.or(new Glob("javassist/*")), JavassistInputStreamInterceptorAdapater.inputStreamAdapterSupplier(JavassistCoverageInterceptor.class)));
    }

    private static Predicate<String> convertToJVMClassFilter(Predicate<String> child) {
        return a -> child.test(a.replace("/", "."));
    }

    private static List<TestUnit> getTestsFromParent(SafeDataInputStream dis, CoverageOptions paramsFromParent) throws IOException {
        List<ClassName> classes = CoverageMinion.receiveTestClassesFromParent(dis);
        Collections.sort(classes);
        Configuration testPlugin = CoverageMinion.createTestPlugin(paramsFromParent);
        CoverageMinion.verifyEnvironment(testPlugin);
        List<TestUnit> tus = CoverageMinion.discoverTests(testPlugin, classes);
        DependencyFilter filter = new DependencyFilter(new DependencyExtractor(new ClassPathByteArraySource(), paramsFromParent.getDependencyAnalysisMaxDistance()), paramsFromParent.getFilter());
        List<TestUnit> filteredTus = filter.filterTestsByDependencyAnalysis(tus);
        LOG.info("Dependency analysis reduced number of potential tests by " + (tus.size() - filteredTus.size()));
        return filteredTus;
    }

    private static List<TestUnit> discoverTests(Configuration testPlugin, List<ClassName> classes) {
        FindTestUnits finder = new FindTestUnits(testPlugin);
        List<TestUnit> tus = finder.findTestUnitsForAllSuppliedClasses(classes.stream().flatMap(ClassName.nameToClass()).collect(Collectors.toList()));
        LOG.info("Found  " + tus.size() + " tests");
        return tus;
    }

    private static Configuration createTestPlugin(CoverageOptions paramsFromParent) {
        ClientPluginServices plugins = new ClientPluginServices(IsolationUtils.getContextClassLoader());
        MinionSettings factory = new MinionSettings(plugins);
        Configuration testPlugin = factory.getTestFrameworkPlugin(paramsFromParent.getPitConfig(), ClassloaderByteArraySource.fromContext());
        return testPlugin;
    }

    private static void verifyEnvironment(Configuration config) {
        LOG.info("Checking environment");
        if (config.verifyEnvironment().isPresent()) {
            throw config.verifyEnvironment().get();
        }
    }

    private static List<ClassName> receiveTestClassesFromParent(SafeDataInputStream dis) {
        int count = dis.readInt();
        LOG.fine("Expecting " + count + " tests classes from parent");
        ArrayList<ClassName> classes = new ArrayList<ClassName>(count);
        for (int i = 0; i != count; ++i) {
            classes.add(ClassName.fromString(dis.readString()));
        }
        LOG.fine("Tests classes received");
        return classes;
    }
}

