/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.functional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class FArray {
    public static <T> void filter(T[] xs, Predicate<T> predicate, Collection<T> dest) {
        if (xs != null) {
            for (T x : xs) {
                if (!predicate.test(x)) continue;
                dest.add(x);
            }
        }
    }

    public static <T> List<T> filter(T[] xs, Predicate<T> predicate) {
        ArrayList dest = new ArrayList();
        FArray.filter(xs, predicate, dest);
        return dest;
    }

    public static <T> boolean contains(T[] xs, Predicate<T> predicate) {
        for (T x : xs) {
            if (!predicate.test(x)) continue;
            return true;
        }
        return false;
    }

    public static <A, B> void flatMapTo(A[] as, Function<A, ? extends Iterable<B>> f, Collection<? super B> bs) {
        if (as != null) {
            for (A a : as) {
                for (B each : f.apply(a)) {
                    bs.add(each);
                }
            }
        }
    }

    public static <A, B> List<B> flatMap(A[] as, Function<A, ? extends Iterable<B>> f) {
        List bs = FArray.emptyList();
        FArray.flatMapTo(as, f, bs);
        return bs;
    }

    private static <T> List<T> emptyList() {
        return new ArrayList();
    }
}

