/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators;

import java.util.HashMap;
import java.util.Map;
import org.pitest.mutationtest.engine.gregor.AbstractInsnMutator;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.mutationtest.engine.gregor.ZeroOperandMutation;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;

class PrimitivesReturnValsMethodVisitor
extends AbstractInsnMutator {
    private static final Map<Integer, ZeroOperandMutation> MUTATIONS = new HashMap<Integer, ZeroOperandMutation>();

    PrimitivesReturnValsMethodVisitor(MethodMutatorFactory factory, MethodInfo methodInfo, MutationContext context, MethodVisitor writer) {
        super(factory, methodInfo, context, writer);
    }

    private static ZeroOperandMutation lreturnMutation() {
        return new ZeroOperandMutation(){

            @Override
            public void apply(int opcode, MethodVisitor mv) {
                mv.visitInsn(88);
                mv.visitInsn(9);
                mv.visitInsn(173);
            }

            @Override
            public String decribe(int opCode, MethodInfo methodInfo) {
                return "replaced long return with 0 for " + methodInfo.getDescription();
            }
        };
    }

    private static ZeroOperandMutation freturnMutation() {
        return new ZeroOperandMutation(){

            @Override
            public void apply(int opcode, MethodVisitor mv) {
                mv.visitInsn(87);
                mv.visitInsn(11);
                mv.visitInsn(174);
            }

            @Override
            public String decribe(int opCode, MethodInfo methodInfo) {
                return "replaced float return with 0.0f for " + methodInfo.getDescription();
            }
        };
    }

    private static ZeroOperandMutation dreturnMutation() {
        return new ZeroOperandMutation(){

            @Override
            public void apply(int opCode, MethodVisitor mv) {
                mv.visitInsn(88);
                mv.visitInsn(14);
                mv.visitInsn(175);
            }

            @Override
            public String decribe(int opCode, MethodInfo methodInfo) {
                return "replaced double return with 0.0d for " + methodInfo.getDescription();
            }
        };
    }

    private static ZeroOperandMutation ireturnMutation() {
        return new ZeroOperandMutation(){

            @Override
            public void apply(int opCode, MethodVisitor mv) {
                mv.visitInsn(87);
                mv.visitInsn(3);
                mv.visitInsn(172);
            }

            @Override
            public String decribe(int opCode, MethodInfo methodInfo) {
                return this.makeMessage(methodInfo.getMethodDescriptor()) + " for " + methodInfo.getDescription();
            }

            private String makeMessage(String methodDescriptor) {
                int sort = Type.getReturnType(methodDescriptor).getSort();
                switch (sort) {
                    case 3: {
                        return "replaced byte return with 0";
                    }
                    case 5: {
                        return "replaced int return with 0";
                    }
                    case 2: {
                        return "replaced char return with 0";
                    }
                    case 4: {
                        return "replaced short return with 0";
                    }
                }
                throw new IllegalStateException(methodDescriptor + " does not return integer type");
            }
        };
    }

    @Override
    protected Map<Integer, ZeroOperandMutation> getMutations() {
        return MUTATIONS;
    }

    static {
        MUTATIONS.put(172, PrimitivesReturnValsMethodVisitor.ireturnMutation());
        MUTATIONS.put(175, PrimitivesReturnValsMethodVisitor.dreturnMutation());
        MUTATIONS.put(174, PrimitivesReturnValsMethodVisitor.freturnMutation());
        MUTATIONS.put(173, PrimitivesReturnValsMethodVisitor.lreturnMutation());
    }
}

