/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators.experimental;

import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;

public class SwitchMutator
implements MethodMutatorFactory {
    @Override
    public MethodVisitor create(MutationContext context, MethodInfo methodInfo, MethodVisitor methodVisitor) {
        return new SwitchMethodVisitor(context, methodVisitor);
    }

    @Override
    public String getGloballyUniqueId() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return "EXPERIMENTAL_SWITCH_MUTATOR";
    }

    private final class SwitchMethodVisitor
    extends MethodVisitor {
        private final MutationContext context;

        SwitchMethodVisitor(MutationContext context, MethodVisitor methodVisitor) {
            super(458752, methodVisitor);
            this.context = context;
        }

        @Override
        public void visitTableSwitchInsn(int i, int i1, Label defaultLabel, Label ... labels) {
            Label newDefault = this.firstDifferentLabel(labels, defaultLabel);
            if (newDefault != null && this.shouldMutate()) {
                Label[] newLabels = this.swapLabels(labels, defaultLabel, newDefault);
                super.visitTableSwitchInsn(i, i1, newDefault, newLabels);
            } else {
                super.visitTableSwitchInsn(i, i1, defaultLabel, labels);
            }
        }

        @Override
        public void visitLookupSwitchInsn(Label defaultLabel, int[] ints, Label[] labels) {
            Label newDefault = this.firstDifferentLabel(labels, defaultLabel);
            if (newDefault != null && this.shouldMutate()) {
                Label[] newLabels = this.swapLabels(labels, defaultLabel, newDefault);
                super.visitLookupSwitchInsn(newDefault, ints, newLabels);
            } else {
                super.visitLookupSwitchInsn(defaultLabel, ints, labels);
            }
        }

        private Label[] swapLabels(Label[] labels, Label defaultLabel, Label newDefault) {
            Label[] swapped = new Label[labels.length];
            for (int i = 0; i < labels.length; ++i) {
                Label candidate = labels[i];
                swapped[i] = candidate == defaultLabel ? newDefault : defaultLabel;
            }
            return swapped;
        }

        private Label firstDifferentLabel(Label[] labels, Label label) {
            for (Label candidate : labels) {
                if (candidate == label) continue;
                return candidate;
            }
            return null;
        }

        private boolean shouldMutate() {
            MutationIdentifier mutationId = this.context.registerMutation(SwitchMutator.this, "Switch mutation");
            return this.context.shouldMutate(mutationId);
        }
    }
}

