/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.pitest.extension.common.TestUnitDecorator;
import org.pitest.functional.SideEffect;
import org.pitest.mutationtest.TimeoutLengthStrategy;
import org.pitest.testapi.ResultCollector;
import org.pitest.testapi.TestUnit;
import org.pitest.util.Unchecked;

public final class MutationTimeoutDecorator
extends TestUnitDecorator {
    private final TimeoutLengthStrategy timeOutStrategy;
    private final SideEffect timeOutSideEffect;
    private final long executionTime;

    public MutationTimeoutDecorator(TestUnit child, SideEffect timeOutSideEffect, TimeoutLengthStrategy timeStrategy, long executionTime) {
        super(child);
        this.timeOutSideEffect = timeOutSideEffect;
        this.executionTime = executionTime;
        this.timeOutStrategy = timeStrategy;
    }

    @Override
    public void execute(ResultCollector rc) {
        long maxTime = this.timeOutStrategy.getAllowedTime(this.executionTime);
        FutureTask<?> future = this.createFutureForChildTestUnit(rc);
        this.executeFutureWithTimeOut(maxTime, future, rc);
        if (!future.isDone()) {
            this.timeOutSideEffect.apply();
        }
    }

    private void executeFutureWithTimeOut(long maxTime, FutureTask<?> future, ResultCollector rc) {
        try {
            future.get(maxTime, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    private FutureTask<?> createFutureForChildTestUnit(ResultCollector rc) {
        FutureTask<Object> future = new FutureTask<Object>(this.createRunnable(rc), null);
        Thread thread = new Thread(future);
        thread.setDaemon(true);
        thread.setName("mutationTestThread");
        thread.start();
        return future;
    }

    private Runnable createRunnable(ResultCollector rc) {
        return () -> {
            try {
                this.child().execute(rc);
            }
            catch (Throwable ex) {
                rc.notifyEnd(this.child().getDescription(), ex);
            }
        };
    }
}

