/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testapi;

import org.pitest.testapi.Description;
import org.pitest.testapi.TestUnitState;

public final class TestResult {
    private final Description description;
    private final Throwable throwable;
    private final TestUnitState state;

    public TestResult(Description description, Throwable t) {
        this(description, t, TestUnitState.FINISHED);
    }

    public TestResult(Description description, Throwable t, TestUnitState state) {
        this.description = description;
        this.throwable = t;
        this.state = state;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public TestUnitState getState() {
        return this.state;
    }

    public Description getDescription() {
        return this.description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.throwable == null ? 0 : this.throwable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestResult other = (TestResult)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals((Object)other.state)) {
            return false;
        }
        return !(this.throwable == null ? other.throwable != null : !this.throwable.equals(other.throwable));
    }

    public String toString() {
        return "TestResult [description=" + this.description + ", state=" + (Object)((Object)this.state) + ", throwable=" + this.throwable + "]";
    }
}

