/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testapi.execute;

import java.util.function.Function;
import org.pitest.functional.SideEffect1;
import org.pitest.testapi.TestListener;
import org.pitest.testapi.TestResult;

public enum ResultType {
    PASS(a -> ResultType.success(a)),
    FAIL(a -> ResultType.failure(a)),
    SKIPPED(a -> ResultType.skipped(a)),
    STARTED(a -> ResultType.started(a));

    private final Function<TestResult, SideEffect1<TestListener>> function;

    private ResultType(ResultToListenerSideEffect f) {
        this.function = f;
    }

    public SideEffect1<TestListener> getListenerFunction(TestResult result) {
        return this.function.apply(result);
    }

    public static SideEffect1<TestListener> success(TestResult result) {
        return a -> a.onTestSuccess(result);
    }

    public static SideEffect1<TestListener> failure(TestResult result) {
        return a -> a.onTestFailure(result);
    }

    public static SideEffect1<TestListener> skipped(TestResult result) {
        return a -> a.onTestSkipped(result);
    }

    public static SideEffect1<TestListener> started(TestResult result) {
        return a -> a.onTestStart(result.getDescription());
    }

    private static interface ResultToListenerSideEffect
    extends Function<TestResult, SideEffect1<TestListener>> {
    }
}

