/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.security;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.security.AcceptedPatternsChecker;
import com.opensymphony.xwork2.util.TextParseUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultAcceptedPatternsChecker
implements AcceptedPatternsChecker {
    private static final Logger LOG = LogManager.getLogger(DefaultAcceptedPatternsChecker.class);
    public static final String[] ACCEPTED_PATTERNS = new String[]{"\\w+((\\.\\w+)|(\\[\\d+\\])|(\\(\\d+\\))|(\\['(\\w|[\\u4e00-\\u9fa5])+'\\])|(\\('(\\w|[\\u4e00-\\u9fa5])+'\\)))*"};
    private Set<Pattern> acceptedPatterns;

    public DefaultAcceptedPatternsChecker() {
        this.setAcceptedPatterns(ACCEPTED_PATTERNS);
    }

    @Inject(value="overrideAcceptedPatterns", required=false)
    protected void setOverrideAcceptedPatterns(String acceptablePatterns) {
        LOG.warn("Overriding accepted patterns [{}] with [{}], be aware that this affects all instances and safety of your application!", this.acceptedPatterns, (Object)acceptablePatterns);
        this.acceptedPatterns = new HashSet<Pattern>();
        for (String pattern : TextParseUtil.commaDelimitedStringToSet(acceptablePatterns)) {
            this.acceptedPatterns.add(Pattern.compile(pattern, 2));
        }
    }

    @Inject(value="additionalAcceptedPatterns", required=false)
    protected void setAdditionalAcceptedPatterns(String acceptablePatterns) {
        LOG.warn("Adding additional global patterns [{}] to accepted patterns!", (Object)acceptablePatterns);
        for (String pattern : TextParseUtil.commaDelimitedStringToSet(acceptablePatterns)) {
            this.acceptedPatterns.add(Pattern.compile(pattern, 2));
        }
    }

    @Override
    public void setAcceptedPatterns(String commaDelimitedPatterns) {
        this.setAcceptedPatterns(TextParseUtil.commaDelimitedStringToSet(commaDelimitedPatterns));
    }

    @Override
    public void setAcceptedPatterns(String[] additionalPatterns) {
        this.setAcceptedPatterns(new HashSet<String>(Arrays.asList(additionalPatterns)));
    }

    @Override
    public void setAcceptedPatterns(Set<String> patterns) {
        if (this.acceptedPatterns == null) {
            LOG.debug("Sets accepted patterns to [{}], note this impacts the safety of your application!", patterns);
        } else {
            LOG.warn("Replacing accepted patterns [{}] with [{}], be aware that this affects all instances and safety of your application!", this.acceptedPatterns, patterns);
        }
        this.acceptedPatterns = new HashSet<Pattern>(patterns.size());
        for (String pattern : patterns) {
            this.acceptedPatterns.add(Pattern.compile(pattern, 2));
        }
    }

    @Override
    public AcceptedPatternsChecker.IsAccepted isAccepted(String value) {
        for (Pattern acceptedPattern : this.acceptedPatterns) {
            if (!acceptedPattern.matcher(value).matches()) continue;
            LOG.trace("[{}] matches accepted pattern [{}]", (Object)value, (Object)acceptedPattern);
            return AcceptedPatternsChecker.IsAccepted.yes(acceptedPattern.toString());
        }
        return AcceptedPatternsChecker.IsAccepted.no(this.acceptedPatterns.toString());
    }

    @Override
    public Set<Pattern> getAcceptedPatterns() {
        return this.acceptedPatterns;
    }
}

